/*------------------------------------------
   POPFONT.C -- Popup Editor Font Functions
  ------------------------------------------*/

#include <windows.h>
#include <commdlg.h>

static LOGFONT logfont ;
static HFONT   hFont ;

BOOL PopFontChooseFont (HWND hwnd)
{
     CHOOSEFONT chf ;
     chf.lStructSize    = sizeof (CHOOSEFONT) ;
     chf.hwndOwner      = hwnd ;
     chf.hDC            = NULL ;
     chf.lpLogFont      = &logfont ;
     chf.iPointSize     = 0 ;
     chf.Flags          = CF_INITTOLOGFONTSTRUCT | CF_SCREENFONTS | CF_EFFECTS ;
     chf.rgbColors      = 0 ;
     chf.lCustData      = 0 ;
     chf.lpfnHook       = NULL ;
     chf.lpTemplateName = NULL ;
     chf.hInstance      = NULL ;
     chf.lpszStyle      = NULL ;
     chf.nFontType      = 0 ;               // Returned from ChooseFont
     chf.nSizeMin       = 0 ;
     chf.nSizeMax       = 0 ;
     
     return ChooseFont (&chf) ;
}

void PopFontInitialize (HWND hwndEdit)
{
     GetObject (GetStockObject (SYSTEM_FONT), sizeof (LOGFONT), 
                (PTSTR) &logfont) ;

     hFont = CreateFontIndirect (&logfont) ;
     SendMessage (hwndEdit, WM_SETFONT, (WPARAM) hFont, 0) ;
}

void PopFontSetFont (HWND hwndEdit)
{
     HFONT hFontNew ;
     RECT  rect ;
     
     hFontNew = CreateFontIndirect (&logfont) ;
     SendMessage (hwndEdit, WM_SETFONT, (WPARAM) hFontNew, 0) ;
     DeleteObject (hFont) ;
     hFont = hFontNew ;
     GetClientRect (hwndEdit, &rect) ;
     InvalidateRect (hwndEdit, &rect, TRUE) ;
}

void PopFontDeinitialize (void)
{
     DeleteObject (hFont) ;
}

